unit disptest1;

(*********************************************************
 * Hyundai HP12542R-DYO LC-Display-Testprogramm          *
 * fr Epson SED1565 LCD-Controller                      *
 * copyright (c) Pollin Electronic http://www.pollin.de  *
 * Tassilo Heeg http://www.theeg.de                      *
 * 25.03.2005 fr Windows 95/98/98SE/ME/NT/2000/XP       *
 * Sourcecode fr Borland Delphi 5                       *
 *********************************************************)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, Buttons, ExtCtrls, ComCtrls, Menus,inifiles;

type
  TDispChar = array[0..6] OF BYTE;
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    TrackBar1: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox2: TGroupBox;
    Panel1: TPanel;
    Image1: TImage;
    BitBtn1: TBitBtn;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    Label3: TLabel;
    Label4: TLabel;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn6: TBitBtn;
    MainMenu1: TMainMenu;
    Konfiguration1: TMenuItem;
    Beenden1: TMenuItem;
    OpenDialog1: TOpenDialog;
    GroupBox3: TGroupBox;
    Memo1: TMemo;
    Label5: TLabel;
    BitBtn7: TBitBtn;
    Label6: TLabel;
    GroupBox4: TGroupBox;
    BitBtn5: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Konfiguration1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure Beenden1Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private-Deklarationen }
    printerport: word;
    bmp: TBitmap; // Bitmap zum Laden/Speichern
    DispFont: Array[32..127] OF TDispChar; // Speicher fr den 5x7 Display-Font
    LastMouseX,LastMouseY: integer; // Letzte Koordianten bei Mouse-Down-Ereignis
    procedure LPTWrite(data: byte);
    procedure LPTWriteCtrl(strobe,selectin,autofeed,init: byte);
    procedure WriteSED(adr,data: BYTE);
    procedure WriteSEDControl(data: byte);
    procedure WriteSEDData(data: byte);
    function GetSEDLineAdr(line: byte): byte;
    procedure WriteSEDBitmap;
    procedure InitSED;
    procedure WriteChar(x,y: integer; c: char);
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

uses disptest2,zlportio;

const cDispWidth = 128;
      cDispHeight = 64;
      cDispPageHeight = 8;
      cDispTxtWidth = 21;
      cDispTxtHeight = 8;



{$R *.DFM}

procedure TForm1.LPTWrite;
// ein Byte ins Datenregister des gewhlten Druckerports schreiben
begin
  PortWriteB(printerport,data);
end;

procedure TForm1.LPTWriteCtrl;
// Steuerleitungen setzen
var data: byte;
begin
  data:=0;
  if strobe=0 then data:=data or 1;
  if autofeed=0 then data:=data or 2;
  if init<>0 then data:=data or 4;
  if selectin=0 then data:=data or 8;
  PortWriteB(printerport+2,data);
end;

procedure TForm1.WriteSED;
// ein Byte in Steuer- oder Datenregister des SED1565 schreiben
begin
  LPTWrite(data);
  LPTWriteCtrl(0,adr,1,0);
  LPTWriteCtrl(1,adr,1,0);
  LPTWriteCtrl(0,adr,1,1);
end;

procedure TForm1.WriteSEDControl;
// ein Byte ins Steuerregister des SED1565 schreiben
BEGIN
  WriteSED(0,data);
END;

procedure TForm1.WriteSEDData;
// ein Byte ins Datenregister des SED1565 schreiben
BEGIN
  WriteSED(1,data);
END;

function TForm1.GetSEDLineAdr(line: byte): byte;
// xxx Zur Bildspeicher-Zeile line die logische (Grafik-)Adresse berechnen
// $FF, wenn line nicht existiert
begin
  if line<cDispHeight then
    result:=line
  else
    result:=$FF;
end;

procedure TForm1.WriteSEDBitmap;
// Das angezeigte Bild bertragen
var page,column,row: integer;
    y: byte;
    b: byte;
begin
  for page:=0 to cDispPageHeight-1 do begin
    // Seitenadresse whlen
    WriteSEDControl($B0 OR page);
    // Spaltenadresse = 0 (ganz links)
    WriteSEDControl($10);
    WriteSEDControl($00);
    // Daten eine Page ausgeben
    for column:=0 to cDispWidth-1 do begin
      b:=0;
      for row:=0 to 7 do begin
        y:=GetSEDLineAdr(page*8+row);
        if y<>$FF THEN BEGIN
          if image1.Picture.Bitmap.canvas.Pixels[column,y]=clBlack then begin
            //Pixel setzen
            b:=b or (1 SHL row);
          end;
        end;
      end;
      WriteSEDData(b);
    end;
  end;
end;

procedure TForm1.InitSED;
// SED1565 initalisieren
begin
  LPTWriteCtrl(0,0,0,1); // RESET aktiv
  LPTWriteCtrl(0,0,1,1); // RESET inaktiv

  WriteSEDControl($40); // Start Display Line = 0
  WriteSEDControl($A0); // ADC = norm (normale Anzeigerichtung)
  WriteSEDControl($A3); // LCD-Bias = 1/7
  WriteSEDControl($C0); // OutputMode =0
  WriteSEDControl($28+7); // LCD-Spannungserzeugung/Regelung ein
  WriteSEDControl($20); // V5 Regulator Resistor Ratio = 0 (ohne Fkt. da externer Widerst.)
  WriteSEDControl($AC); // Static Indicator off
  // noch die Einstellungen aus dem Hauptfenster bernehmen
  CheckBox1click(self);
  CheckBox2click(self);
  CheckBox3click(self);
  TrackBar1Change(self);
  // Bild bertragen
  WriteSEDBitmap;
end;

procedure TForm1.FormCreate(Sender: TObject);
var myini: TIniFile;
begin
// Konfiguration (Printerport)
  myini:=TInifile.create(IncludeTrailingBackslash(ExtractFilePath(Application.exename))+'DISPTEST.INI');
  printerport:=myini.readinteger('SED1565','LPTADDRESS',$378);
  myini.free;
  bmp:=TBitmap.create;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var myini: TIniFile;
begin
  // Konfiguration (Printerport)
  myini:=TInifile.create(IncludeTrailingBackslash(ExtractFilePath(Application.exename))+'DISPTEST.INI');
  myini.writeinteger('SED1565','LPTADDRESS',printerport);
  myini.free;
  // Display reset
  LPTWrite(0);
  LPTWriteCtrl(0,0,1,0);
end;

procedure TForm1.Konfiguration1Click(Sender: TObject);
begin
  case printerport of
    $378: form2.combobox1.itemindex:=0;
    $278: form2.combobox1.itemindex:=1;
    else form2.combobox1.itemindex:=2;
  end;
  form2.edit1.text:='$'+IntToHex(printerport,4);
  if form2.combobox1.itemindex<2 then begin
    form2.edit1.enabled:=FALSE;
    form2.edit1.color:=clBtnFace;
  end else begin
    form2.edit1.enabled:=true;
    form2.edit1.color:=clWhite;
  end;
  if form2.showmodal<>idOK then exit;
  case form2.combobox1.itemindex of
    0: printerport:=$378;
    1: printerport:=$278;
    else printerport:=StrToInt(form2.edit1.text);
  end;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  if checkBox1.checked then begin
    WriteSEDControl($A4); // Displaytest aus, damit nicht irgendein StandBy-Mode aktiviert wird
    WriteSEDControl($AF); // Display EIN
    if checkBox3.checked then
      WriteSEDControl($A5) // Alle Pixel ein / Displaytest
  end else begin
    WriteSEDControl($A4); // Displaytest aus, damit nicht irgendein StandBy-Mode aktiviert wird
    WriteSEDControl($AE); // Display AUS
  end;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  if checkBox2.checked then
    WriteSEDControl($A7) // Display invertiert
  else
    WriteSEDControl($A6); // Display normal
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
  if not checkBox1.checked then exit;
  if checkBox3.checked then
    WriteSEDControl($A5) // Alle Pixel ein / Displaytest
  else
    WriteSEDControl($A4); // normaler Betrieb
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  WriteSEDControl($81);
  WriteSEDControl(TrackBar1.position AND $3F); // Kontrast einstellen
  Label2.caption:=IntToStr(TrackBar1.position);
end;

procedure TForm1.Beenden1Click(Sender: TObject);
begin
  close;
end;

procedure TForm1.BitBtn6Click(Sender: TObject);
begin
  close;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  Image1.Canvas.pixels[SpinEdit1.value,SpinEdit2.value]:=clBlack;
  WriteSEDBitmap;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  Image1.Canvas.pixels[SpinEdit1.value,SpinEdit2.value]:=clWhite;
  WriteSEDBitmap;
end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
 InitSED;
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
  image1.Picture.Bitmap.width:=cDispWidth;
  image1.Picture.Bitmap.height:=cDispHeight;
  with image1.Picture.Bitmap.canvas do begin
    pen.color:=clWhite;
    brush.color:=clWhite;
    rectangle(0,0,image1.Picture.Bitmap.width,image1.Picture.Bitmap.height);
  end;
  WriteSEDBitmap;
end;

procedure TForm1.FormShow(Sender: TObject);
var fn: string;
    fntfile: file of byte;
begin
  image1.Picture.Bitmap.width:=cDispWidth;
  image1.Picture.Bitmap.height:=cDispHeight;
  InitSED;
  // Schrift laden
  fn:=IncludeTrailingBackslash(ExtractFilePath(Application.exename))+'DISPTEST.FON';
  if not fileexists(fn) then begin
    ShowMessage('Die bentigte Schriftartdatei '+fn+' mit dem 5x7-Display-Font wurde nicht gefunden!');
    exit;
  end;
  FileMOde:=0;
  AssignFile(fntfile,fn);
  Reset(fntfile);
  BlockRead(fntfile,DispFont,sizeof(DispFont));
  CloseFile(fntfile);
  // Pollin Logo laden
  bmp.Loadfromfile(IncludeTrailingBackslash(ExtractFilePath(Application.exename))+'LOGOSW.BMP');
  (* Image lschen *)
  image1.Picture.Bitmap.width:=cDispWidth;
  image1.Picture.Bitmap.height:=cDispHeight;
  with image1.Picture.Bitmap.canvas do begin
    pen.color:=clWhite;
    brush.color:=clWhite;
    rectangle(0,0,image1.Picture.Bitmap.width,image1.Picture.Bitmap.height);
  end;
  image1.Picture.Bitmap.canvas.Draw(0,0,bmp);
  WriteSEDBitmap;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var r: Trect;
    z1,z2: single;
begin
  if not OpenDialog1.execute then exit;
  bmp.Loadfromfile(opendialog1.filename);
  z1:=image1.height/bmp.height;
  z2:=image1.width/bmp.width;
  (* Image lschen *)
  image1.Picture.Bitmap.width:=cDispWidth;
  image1.Picture.Bitmap.height:=cDispHeight;
  with image1.Picture.Bitmap.canvas do begin
    pen.color:=clWhite;
    brush.color:=clWhite;
    rectangle(0,0,image1.Picture.Bitmap.width,image1.Picture.Bitmap.height);
  end;
  if z1>z2 then begin
    (* Geladenes bild begrenzt durch breite *)
    with r do begin
      left:=0;
      top:=0;
      right:=image1.Picture.Bitmap.width;
      bottom:=round(bmp.height*z2);
    end;
  end else begin
    with r do begin
      left:=0;
      top:=0;
      right:=round(bmp.width*z1);
      bottom:=image1.Picture.Bitmap.height;
    end;
  end;
  image1.Picture.Bitmap.canvas.StretchDraw(r,bmp);
  WriteSEDBitmap;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  bmp.free;
end;

procedure TForm1.WriteChar;
// Ein Zeichen in das Bitmap am Bildschirm schreiben, nicht ans Display senden
var xz,yz: integer;
    i: byte;
begin
  if (c<#32) or (c>#127) then c:='?';
  i:=ord(c);
  for yz:=0 to 7 do begin
    if yz<7 then
      for xz:=0 to 5 do begin
        if (DispFont[i][yz] AND (16 SHR xz))<>0 then
          Image1.Canvas.pixels[x+xz,y+yz]:=clBlack
        else
          Image1.Canvas.pixels[x+xz,y+yz]:=clWhite;
      end
    else
      for xz:=0 to 5 do
        Image1.Canvas.pixels[x+xz,y+yz]:=clWhite;
  end;
end;

procedure TForm1.BitBtn7Click(Sender: TObject);
var col,row: byte;
    s: string;
begin
  for row:=0 to cDispTxtHeight do begin
    if Memo1.lines.count>row then s:=Memo1.lines[row] else s:='';
    while length(s)<cDispTxtWidth do s:=s+' ';
    for col:=0 to cDispTxtWidth-1 do
      WriteChar(col*6,row*8,s[col+1]);
  end;
  WriteSEDBitmap;
end;

procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  case Button of
    mbLeft: BEGIN
              Image1.canvas.pixels[x,y]:=clBlack;
              LastMouseX:=x;
              LastMouseY:=y;
            END;
    mbRight:BEGIN
              Image1.canvas.pixels[x,y]:=clWhite;
              LastMouseX:=x;
              LastMouseY:=y;
            END;
  end;
end;

procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if ssLeft in Shift then begin
    // Linker Masuknopf gedrckt
    Image1.canvas.pen.color:=clBlack;
    Image1.canvas.MoveTo(LastMouseX,LastMouseY);
    Image1.canvas.LineTo(x,y);
    Image1.canvas.pixels[x,y]:=clBlack;
    LastMouseX:=x;
    LastMouseY:=y;
  end else if ssRight in Shift then begin
    // Linker Masuknopf gedrckt
    Image1.canvas.pen.color:=clWhite;
    Image1.canvas.MoveTo(LastMouseX,LastMouseY);
    Image1.canvas.LineTo(x,y);
    Image1.canvas.pixels[x,y]:=clWhite;
    Image1.canvas.pen.color:=clWhite;
    LastMouseX:=x;
    LastMouseY:=y;
  end;

end;

procedure TForm1.Image1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  WriteSEDBitmap;
end;

end.
